/**
 * This is the interface which provides the methods for the GUI package and the Database package.
 * 
 * @author Andreas Arnold, Fabian Kueng, Patric Uebersax
 * @version Version 0.10
 */

package control;

import gui.SearchField;

import java.util.Collection;

import db.info.Info;

public interface ControllerInterface {
	
	/**
	 * Gets a SearchField object and returns the collection with all results.
	 * @param results SearchField object with all fields of the Search-Frame.
	 * @return The results from the search.
	 */
	public Collection search(SearchField results);
	
	/**
	 * Removes an info-object from the database.
	 * @param info The Object to remove.
	 */
	public void remove(Info info);
	
	/**
	 * Saves an info-object to the database.
	 * @param info The object to save.
	 */
	public void save(Info info);
}
