/**
 * Searches for the full text.
 * 
 * @author Andreas Arnold, Fabian Kueng, Patric Uebersax
 * @version Version 0.10
 */

package control.search;

import db.info.Info;

public class AuthorSearch implements SimpleCriteria{
 
	
	/** The string from the user-input */
	String author;

	
	/**
	 * Adds the string from user-input to the variable.
	 * @param _author The user-input in the field author.
	 */
	public AuthorSearch(String _author) {
		author = _author;
	}
	
	
	/**
	 * Checks if the Info-object author matches the user input.
	 * @return True if there are the same text, false otherwise.
	 */
	public boolean match(Info info) {
		return Utility.matchText(info.getAuthor(), author);
	}
}
