/**
 * Controlls if the date is before the entered one.
 * 
 * @author Andreas Arnold, Fabian Kueng, Patric Uebersax
 * @version Version 0.10
 */

package control.search;

import java.util.Date;

import db.info.Info;

public class FromDateSearch implements SimpleCriteria{

	
	/** The string from the user-input */
	Date fromDate;

	
	/**
	 * Adds the string from user-input to the variable.
	 * @param _fromDate The user-input in the field fromDate.
	 */
	public FromDateSearch(Date _fromDate) {
		fromDate = _fromDate;
	}
	
	
	/**
	 * Checks if the user input is before the info-object date.
	 * @return True if there are the same text, false otherwise.
	 */
	public boolean match(Info info) {
		return fromDate.before(info.getDate());
	}

}
