/**
 * Searches for the full text.
 * 
 * @author Andreas Arnold, Fabian Kueng, Patric Uebersax
 * @version Version 0.10
 */

package control.search;

import db.info.Info;

public class FullTextSearch implements SimpleCriteria{
	
	
	/** The string from the user-input */
	String fullText;

	
	/**
	 * Adds the string from user-input to the variable.
	 * @param _fullText The user-input in the field fullText.
	 */
	public FullTextSearch(String _fullText) {
		fullText = _fullText;
	}
	
	/**
	 * Checks if the Info-object text matches the user input.
	 * @return True if there are the same text, false otherwise.
	 */
	public boolean match(Info info) {
		return Utility.matchText(info.getText(), fullText);
	}

}
