/**
 * Searches for the hierarchy.
 * 
 * @author Andreas Arnold, Fabian Kueng, Patric Uebersax
 * @version Version 0.10
 */

package control.search;

import java.util.Collection;
import java.util.Iterator;

import db.info.Info;

public class HierachySearch implements SimpleCriteria{

	/** The string from the user-input */
	Iterator hierarchy;

	
	/**
	 * Adds the string from user-input to the variable.
	 * @param _hierarchy The user-input in the field hierarchy.
	 */
	public HierachySearch(Collection _hierarchy) {
		hierarchy = _hierarchy.iterator();
	}
	
	
	/**
	 * Checks if the Info-object hierarchy matches the user input.
	 * @return True if there are the same text, false otherwise.
	 */
	public boolean match(Info info) {
		boolean match = false;
		Iterator it = info.getHierarchys().iterator();
		String catName;
		lab:while(hierarchy.hasNext()) {
			catName = (String) hierarchy.next();
			while(it.hasNext()) {
				if(it.next() == catName) {
					match = true;
					break lab;
				}
			}
		}
		return false;
	}
}
