/**
 * The different types to search for are here specified, and it matches all strings
 * to this types.
 * 
 * @author Andreas Arnold, Fabian Kueng, Patric Uebersax
 * @version Version 0.10
 */

package control.search;

import java.util.ArrayList;
import java.util.Iterator;

import db.info.Info;

public class SearchCriteria{
	
	/** All simpleCriterias to check for. */
	ArrayList simpleCriterias = new ArrayList();
	
	
	/**
	 * Adds a simpleCriteria to the ArrayList.
	 * @param sc The reference to a simpleCriteria to search for.
	 */
	public void add(SimpleCriteria sc) {
		simpleCriterias.add(sc);
	}
	
	
	/**
	 * Matches an info-object to all criterias that are needed.
	 * If one of the simpleCriterias returns false, the Info-object will return false.
	 * 
	 * @param info The Info-object to control for.
	 * @return True if everything is ok, false if one of the conditions are false.
	 */
	public boolean match(Info info) {
		boolean match = true;
		Iterator it = simpleCriterias.iterator();
		while(it.hasNext()) {
			SimpleCriteria sc = (SimpleCriteria) it.next();
			match &= sc.match(info);
			if(match) {
				break;
			}
		}
		return match;
	}

}