/**
 * Searches for the full text.
 * 
 * @author Andreas Arnold, Fabian Kueng, Patric Uebersax
 * @version Version 0.10
 */

package control.search;

import db.info.Info;

public class TitleSearch implements SimpleCriteria{
	
	/** The string from the user-input */
	String title;

	
	/**
	 * Adds the string from user-input to the variable.
	 * @param _title The user-input in the field title.
	 */
	public TitleSearch(String _title) {
		title = _title;
	}
	
	
	/**
	 * Checks if the Info-object title matches the user input.
	 * @return True if there are the same text, false otherwise.
	 */
	public boolean match(Info info) {
		return Utility.matchText(info.getTitle(), title);
	}
}
