/**
 * Searches for the full text.
 * 
 * @author Andreas Arnold, Fabian Kueng, Patric Uebersax
 * @version Version 0.01
 */

package control.search;

import java.util.Date;

import db.info.Info;

public class ToDateSearch implements SimpleCriteria{

	/** The string from the user-input */
	Date toDate;

	
	/**
	 * Adds the date from user-input to the variable.
	 * @param _toDate The user-input in the field fullText.
	 */
	public ToDateSearch(Date _toDate) {
		toDate = _toDate;
	}
	
	
	/**
	 * Checks if the user input is after the info-object date.
	 * @return True if there are the same text, false otherwise.
	 */
	public boolean match(Info info) {
		return toDate.after(info.getDate());
	}

}