/*
 * Created on 25.11.2005
 */
package db;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import control.search.SearchCriteria;
import db.info.DummyData;
import db.info.Hierarchy;
import db.info.Info;

/**
 * @author patrizia.moser and Uemi Oezcan
 *
 */
public class DBAccess implements DBInterface{
	HashSet hs;
	
	DBAccess(){
		try {
			hs = (HashSet) Persistent.load();
		} catch (Exception e) {
			DummyData dd = new DummyData();
			hs = dd.getDummyData();
			//hs = new HashSet();
		}
		
		// save at shutdown
		MyRunnable r = new MyRunnable(this);
		Runtime runt = Runtime.getRuntime();
		Thread t = new Thread(r);
		runt.addShutdownHook(t);
	}
	
	
	
	public void saveInfo(Info info) {
	    
	    if(null != info) {
	        System.out.println("Saved!");
			hs.add(info);
	    }
	}
	
	public void removeInfo(Info info) {
		hs.remove(info);
	}
	
	
	public Hierarchy getTopHierarchy() {
		// TODO Auto-generated method stub
		return null;
	}

	
	public void setTopHierarchy(Hierarchy top) {
		// TODO Auto-generated method stub
	}
	
	
	public Collection getResultSet(SearchCriteria sk){
		ArrayList array = new ArrayList();
		for (Iterator iter = hs.iterator(); iter.hasNext();) {
			Info info = (Info) iter.next();
			if(null == sk || sk.match(info)){
			array.add(info);
			}
		}
		return array;
	}
	
	
	public void save(){
		System.out.println("Save...");
		try{
		  Persistent.save(hs);
		} catch (Exception ex) {
			System.err.println("Error in DBAccess.save() :" + ex);
		}
	}
}
	
    /** 
     * Save the application-data.
     * TODO: remove in case of JDBC or other relational database.
     * 
     * @author patrizia.moser
     *
     */
	class MyRunnable implements Runnable{
		DBAccess theInstance;
		
		public MyRunnable(DBAccess instance){
			theInstance = instance;
		}
		
		public void run() {
			theInstance.save();
		}
	}
		


	

