/**
 * Created on 18.05.2005
 * @author uemi.oezcan, patrizia.moser
 */

package db;

import java.util.*;

import control.search.*;
import db.info.*;


public interface DBInterface{ 
	
	/**
	 * 
	 * Add new Information (Notice, fulltext)to Collection 
	 *  @param info
	 */
	public void saveInfo(Info info);

	/**
	 * Removes a single instance of the specified element 
	 * from this collection.
	 * @param info
	 */
	public void removeInfo(Info info);
	
	/**
	 * Compare SearchCriteria with Info. 
	 * Return Collection with matching Info's.
	 * @param sk
	 * @return Collection
	 */
	public Collection getResultSet(SearchCriteria sk);

	/**
	 * 
	 * @return Hierarchy
	 */
	public Hierarchy getTopHierarchy();
	
	/**
	 * 
	 * @param top
	 */
	public void setTopHierarchy(Hierarchy top);
	
	//TODO: next version: update();
	
}
