package db;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

/**
 *                   <code>Persistent</code>
 * This class is used to hold the data permanent.
 * Call "load()" at startup of the application and call "save()"
 * at the end.
 * @author Philipp Gressly (phi@gressly.ch)
 */
/*
 * History: first Implementation: 23.11.2005
 * Bugs   :
 */
public class Persistent {
    
    final static String INFODB_FILE_NAME = "InfoDB.joz";
    
    public static void save(Object data) throws IOException {
        File file = new File(INFODB_FILE_NAME);
        FileOutputStream fos = new FileOutputStream(file); // Save to file
        GZIPOutputStream gzos = new GZIPOutputStream(fos); // Compressed
        ObjectOutputStream out = new ObjectOutputStream(gzos);// Save objects
        out.writeObject(data); // Write the entire Vector of scribbles
        out.flush(); // Always flush the output.
        out.close(); // And close the stream.
    }

    public static Object load() throws Exception {
        Object result = null;
        File inFile = new File(INFODB_FILE_NAME);
        FileInputStream fis = new FileInputStream(inFile);// Read from file
        GZIPInputStream gzis = new GZIPInputStream(fis); // Uncompress
        ObjectInputStream in = new ObjectInputStream(gzis); // Read objects
        // Read in an object. It should be an AllData object
        try {
            result = in.readObject();
        } catch (ClassNotFoundException cnfe) {
            throw new IOException("Class Not Found in SysTools.load() :\n"
                    + cnfe);
        }
        in.close(); // Close the stream.
        //System.out.println("Data gelesen.");
        return result;
    }

}  // end of class Persistent