/**
 * Created on 18.05.2005
 * @author uemi.oezcan, patrizia.moser
 */

package db.info;

import java.util.ArrayList;
import java.util.Collection;

public class Hierarchy {
	
	/**
	 * Erstellt Struktur der Hierarchie
	 */
	
	private String name;

	private Hierarchy parent;

	private Collection children = null;

	
	public Hierarchy (String name){
	  this(null, name);	
	}
	public Hierarchy(Hierarchy parent, String name){
	   setParent(parent);	
	   this.name=name;
	}
	
	public void setParent(Hierarchy parent) {
		this.parent = parent;
		Hierarchy child = this;
		if(null != parent) {
			parent.addChild(child);
		}
	}
	
	public void addChild(Hierarchy hier){
	   if(null == children){
	     children  = new ArrayList();
	   }
	   children.add(hier);
	}
	
	public Hierarchy getParent(){
	  return this.parent;	
	}

	public String getName(){
	   return this.name;	
	}
	
	public Collection getChildren(){
	  	return children;
	}
	
	public String toString() {
	    return getName();
	}

}
