package gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.ParseException;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JTextField;

import control.ControllerImplementation;
import control.ControllerInterface;
import db.info.Info;

/**
 * @author philipp.bockhorn
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class Create extends InfoPanel {
    
    // Create JButtons
    JButton btnSave;
    JButton btnReset;
    
    // References to controller interface and Show
    ControllerInterface controllerInterface;
    
    public Create() {
             
    }
   
    public Create(Info info) {
        
        super(info);
        setInfoValuesIntoTheFields(info);
    }
    
    public void generateComponents() {
        
        super.generateComponents();
                
	    // JButtons werden erstellt
	    btnSave = new JButton(InfoResources.getResourceString("create.save.button.text"));
	    btnSave.setActionCommand(InfoResources.getResourceString("create.save.ActionCommand.text"));
	    btnReset = new JButton(InfoResources.getResourceString("create.reset.button.text"));
	    btnReset.setActionCommand(InfoResources.getResourceString("create.reset.ActionCommand.text"));
	    try {
			btnReset = new JButton(menu.getAction(MainPanel.ACTION_ID_NOTE_RESET));
			} catch (IllegalActionModifierException e) {
			e.printStackTrace();
		}
		btnReset.addActionListener(new ActionListener() {

	        public void actionPerformed(ActionEvent arg0) {
	        	System.out.println("user name");
	        	txtAuthor.setText(System.getProperty("user.name"));
	        	txtTitle.setText("");
	    	    txtTitle.requestFocusInWindow();
	                
	            }
			});
    }
    
    public void addComponents() {
        
        super.addComponents();
        
		// Save - Button
		layoutComponent(btnSave, 0, 14);
		// Reset - Button
		layoutComponent(btnReset, 1, 14);
		

		/*
		 * ActionListeners
		 */
		controllerInterface = ControllerImplementation.getInstance();
		
		// TODO
		try{
			btnSave.addActionListener(menu.getAction(MainPanel.ACTION_NOTE_SAVE));
			btnSave.addActionListener(menu.getAction(MainPanel.ACTION_DIRTY));
			
		} catch(IllegalActionModifierException e) {
			System.out.println("Illegal Action Modifier");
		}
    }


    /**
     * Tells the caller, if this Dialog has only empty fields.
     * In this case, the dialog may be disposed without warning.
     * Empty is not the same as "untouched". If a user fills somethig in, and deletes it afterwards, a dialog may be "empty", but surely is not untouched!
     * @return true, iff all fields are empty. 
     */
    public boolean isEmpty() {
        return 
            txtAuthor.equals("") && 
            panelHierarchy.equals("") && 
            //txtDate.equals("") &&
            txtNote.equals("") &&
            txtTitle.equals("");
        }

	/**
	 * @param info
	 * @throws ParseException
	 */
	public Info fillInfo(Info info) throws ParseException {
		info.setAuthor(getTxtAuthor());
		info.setText(getTxtNote());
		//info.setDate(GUIUtility.formatDate(getTxtDate()));
		info.setTitle(getTxtTitle());
		info.setDate(new Date());
		info.setHierarchy(getTxtCategory());
		
		return info;
		
	}
}