	package gui;
	
	import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
	import java.awt.event.WindowAdapter;
	import java.awt.event.WindowEvent;
	import java.util.ArrayList;
	import javax.swing.JFrame;
	
	import db.info.Info;
	
	/**
	 * @author patrizia.moser, jennifer.meyer
	 */
	public class GUIFrame extends JFrame {
	
		private static ArrayList arrayList = new ArrayList();
		public static final int PANELTYPE_SEARCH			 = 1;
		public static final int PANELTYPE_SHOW 				 = 2;
		public static final int PANELTYPE_CREATE_OR_CHANGE   = 3;
		private static int frameNumber = 0;
		
		private GUIFrame(){
			super(InfoResources.getResourceString("gui.guiFrame.title.text"));
			this.setSize(InfoResources.getResourceInt("gui.GUIFrame.size.w"),
					     InfoResources.getResourceInt("gui.GUIFrame.size.h")								
			            ); 
			Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
		    setLocation( (d.width  - getSize().width ) / 2-30*frameNumber,
		                 (d.height - getSize().height) / 2+30*frameNumber );
		    frameNumber++;
		    
			
			this.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
			this.addWindowListener(new WindowAdapter() {
			    /**
			     * close the application, if this was the last window
			     * to close.
			     */
				public void windowClosing(WindowEvent e) {
					arrayList.remove(e.getWindow());
					if(arrayList.isEmpty()){
						System.out.println("Last window is closing!!!");
						System.exit(0);
					}
				}	
			});
		}
		/** 
		 * @param panelType one of the above: SEACH, SHOW, CREATE_OR_CHANGE
		 * @param info important for SHOW and CREATE_OR_CHANGE.
		 *        leave "null" in the case of "SEARCH".
		 */
		public static void openNewFrame(int panelType, Info info){
			GUIFrame guiFrame = new GUIFrame();
			arrayList.add(guiFrame);
			switchToPanel(guiFrame, panelType, info);
			
			guiFrame.setVisible(true);
		}
		
		public static void switchToPanel(GUIFrame actFrame, int panelType, Info info ){
			MainPanel mainPanel;
			mainPanel = createInfoPanel(panelType, info);
			actFrame.setContentPane(mainPanel);	
			actFrame.validate();
		}
        
		public static void switchToPanel(MainPanel infoPanel, int panelType, Info info ){
	        GUIFrame guiFrame = getFrameFromPanel(infoPanel);

	        switchToPanel(guiFrame, panelType,info);
		}
		/**
		 * Returns the GUIFrame that belongs to the infoPanel.
		 * If this infoPanel is not yet attached to a GUIFrame, this method
		 * will return null.
		 * @param infoPanel
		 * @return
		 */
		public static GUIFrame getFrameFromPanel(MainPanel infoPanel){
			Component actComponent = infoPanel;

	        while(! (actComponent instanceof GUIFrame)) {
	        	if(null == actComponent){
	        		return null;
	             }
	        	actComponent = actComponent.getParent(); 
	        }
	        return (GUIFrame) actComponent;
	        
	        
		}
		
		private static MainPanel createInfoPanel(int panelType, Info info){
			switch(panelType){
			case PANELTYPE_SEARCH:				
				return  new Search();
				
			case PANELTYPE_SHOW:				 
				return  new Show(info);
		
			case PANELTYPE_CREATE_OR_CHANGE:	
				return  new Create(info);
			
			default:
				return new Create(info);
		    }	
		}
	
	}
