// fill rest/reminder
package gui;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.util.Calendar;
import java.util.GregorianCalendar;

import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

import db.info.Info;

/*
 * Created on 17.05.2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */

/**
 * @author philipp.bockhorn
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class InfoPanel extends MainPanel {
	
	
    JLabel lblDate; //Text Datum
    JLabel lblTitle;
    JLabel lblNote;
    JLabel txtDate; //Inhalt Datum
    
    // JTextField werden erstellt
    JTextField txtTitle;
    JTextArea txtNote;
    
    
    
    // JButtons werden erstellt
    JButton btnSave;
    
    // LineCanvas wird erstellt
    LineCanvas lnCanvas1;
    LineCanvas lnCanvas2;
    LineCanvas lnCanvas3;
    LineCanvas lnCanvas4;
    LineCanvas lnCanvas5;
    LineCanvas lnCanvas6;
    
    //Info/(Note) reference
    Info actInfo;
    
    InfoPanel partnerPanel;
    //AddPanel 
    public InfoPanel() {
    	enableMenu(false, false, false);
    	 }
    //EditPanel
    public InfoPanel(Info info) {
        
        actInfo = info;
        setInfoValuesIntoTheFields(info);
        enableMenu(false, false, false);
    }
    
    public Info getInfo() {
        
        return actInfo;
    }
    
    //use for infopanel and editpanel --> menubar
    public void enableMenu(boolean showEnable, boolean editEnable, boolean deleteEnable){
    	try {
			getAction(InfoPanel.ACTION_ID_NOTE_SHOW).setEnabled(showEnable);
			getAction(InfoPanel.ACTION_ID_NOTE_EDIT).setEnabled(editEnable);
			getAction(InfoPanel.ACTION_ID_NOTE_DELETE).setEnabled(deleteEnable);
		} catch (IllegalActionModifierException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
    }
    public void setInfoValuesIntoTheFields(Info info) {
        
        if(null != info) {
            
            txtAuthor.setText(info.getAuthor());
    	    txtTitle.setText(info.getTitle());
    	    txtNote.setText(info.getText());
        }
    }
    
    public void generateComponents() {
        super.generateComponents();
        
        GregorianCalendar gc = new GregorianCalendar();
    	
	    // JLabel werden erstellt
        lblAuthor = new JLabel(InfoResources.getResourceString("infopanel.label.author.text")+":");
	    lblTitle = new JLabel(InfoResources.getResourceString("infopanel.label.title.text")+":");
	    lblDate = new JLabel(InfoResources.getResourceString("infopanel.label.date.text")+":");
	    lblNote = new JLabel(InfoResources.getResourceString("infopanel.label.note.text")+":");
	    lblHierarchy = new JLabel(InfoResources.getResourceString("infopanel.label.category.text")+":");
	    lblFill = new JLabel("");
	    
	    // JTextField werden erstellt
	  
	    
	    txtAuthor = new JTextField(System.getProperty("user.name"));
	    txtAuthor.setName("txtAuthor");
	    txtTitle = new JTextField("");
	    txtTitle.requestFocusInWindow();
	    txtDate = new JLabel(gc.get(Calendar.DATE)+"."+(gc.get(Calendar.MONTH)+1) +"."+gc.get(Calendar.YEAR));
	    txtNote = new JTextArea("");
	    
	    
	    // LineCanvas wird erstellt
	    lnCanvas1 = new LineCanvas();
	    lnCanvas2 = new LineCanvas();
	    lnCanvas3 = new LineCanvas();
	    lnCanvas4 = new LineCanvas();
	    lnCanvas5 = new LineCanvas();
        lnCanvas6 = new LineCanvas(false, true);
        lnCanvas6.setBackground(new Color(0, 128, 0));
        lnCanvas6.setOpaque(true);
        /*
         	  lnCanvas6 braucht es sehr wahrscheinlich nicht mehr. Nach den Angaben
        	  von Philipp Boockhorn. 
        	  --> code fr new Color und frs Properties file.
        	 (gui.InfoPanel.addComponents.color=
        	 InfoResources.getResourceColor(""))
        */
    }
    
    public void addComponents() {
        
        super.addComponents();
    	
        int widht = InfoResources.getResourceInt("gui.InfoPanel.addComponents.w");
        int height = InfoResources.getResourceInt("gui.InfoPanel.addComponents.h");
//      Titel - Label
		layoutComponent(lblTitle, 0, rowCounter);
		// Titel - Textfeld
		layoutComponent(txtTitle, 1, rowCounter);
        
		// Kategorie - Label
		layoutComponent(lblHierarchy, 3, rowCounter);
		//switch to the next row
		rowCounter++;
		
		
		
//		 Autor - Label
		layoutComponent(lblAuthor, 0, rowCounter);
		lblAuthor.setPreferredSize(new Dimension (widht, height));
		// Autor - Textfeld
		layoutComponent(txtAuthor, 1, rowCounter);
		txtAuthor.setPreferredSize(new Dimension (widht, height));
		//switch to the next row
		rowCounter++;
		
//		 Datum - Label
		layoutComponent(lblDate, 0, rowCounter);
		// Datum - Textfeld
		layoutComponent(txtDate, 1, rowCounter);
		rowCounter ++;
		
		// Kategorie - Textfeld
		layoutComponent(panelHierarchy, 3, 1, 1, 3, 1.0, 1.0, true);

		
		// LineCanvas: Vertikal Ruler
		layoutComponent(lnCanvas6, 2, 0, 1, rowCounter+1, 0.0, 1.0, true);
		//switch to the next row
		rowCounter++;
		
		// LineCanvas: 2. Horiz. Ruler
		layoutComponent(lnCanvas2, 0, rowCounter, 4, 1);
		//switch to the next row
		rowCounter++;
		
		// Notiz - Label
		layoutComponent(lblNote, 0, rowCounter);
		//switch to the next row
		rowCounter ++;
		
		// Notiz - Textfeld
		JScrollPane scrollingResult = new JScrollPane(txtNote);

		layoutComponent(scrollingResult, 0, rowCounter, 4, 1, 1.0, 1.0, true);
		//switch to the next row
		rowCounter++;

		// LineCanvas: 3. Horiz. Ruler
		layoutComponent(lnCanvas3, 0, rowCounter, 4, 1);
		//switch to the next row 
		rowCounter++;

		// Action Dirty
		txtAuthor.getDocument().addDocumentListener(super.getDocumentListener());
		txtNote.getDocument().addDocumentListener(super.getDocumentListener());
		txtTitle.getDocument().addDocumentListener(super.getDocumentListener());		
    }
    
	/**
	 * @return Returns the txtAuthor.
	 */
	public String getTxtAuthor() {
		return txtAuthor.getText();
	}
	/**
	 * @return Returns the txtCategory.
	 */
	public String getTxtCategory() {
		return ""; // TODO this method does not make sense?
	}
	/**
	 * @return Returns the txtDate.
	 */
	public String getTxtDate() {
		return txtDate.getText();
	}
	/**
	 * @return Returns the txtNote.
	 */
	public String getTxtNote() {
		return txtNote.getText();
	}
	/**
	 * @return Returns the txtTitle.
	 */
	public String getTxtTitle() {
		return txtTitle.getText();
	}
	
	/**
	 * @return
	 */
	public  InfoPanel getPartnerPanel() {
		return this.partnerPanel;
	}

     public void setPartnerPanel(InfoPanel newPartner){
       this.partnerPanel = newPartner;
     }

	public void invalidDate() {
		txtDate.setText("");
		lblDate.setForeground(Color.RED);
		this.updateUI();
	}
}