package gui;

import java.awt.*;
import javax.swing.*;

class LineCanvas extends JPanel 
{
    boolean shortLine;
	boolean vertical = false;

	public LineCanvas() 
	{
	    this(false, false);
	}
	
	public LineCanvas(boolean shortLine, boolean vertical) 
	{
	    this.shortLine = shortLine;
		this.vertical = vertical;
	}
	
	public LineCanvas(boolean shortLine)
	{
		this(shortLine, false);
	}
	public void paint(Graphics g) 
	{
	    g.setColor(Color.BLACK);

		if(vertical) 
		{
		    int h = getHeight();
		    int height = (int) (h * 0.7);
		    if(shortLine)
		    {
		        g.fillRect(0, 0, 2, height);
		    }
		    else
		    {		        
		          g.fillRect(0, 0, 2, h);
		    }
		} 
		else 
		{
		    int w = getWidth();
		    int length = (int) (w * 0.7);
		    if(shortLine)
		    {
		        g.fillRect(0, 0, length, 2);
		    }
		    else
		    {
		          g.fillRect(0, 0, w, 2);
		    }
		}
	}
}
