package gui;

import gui.actions.MyDocumentListener;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.MenuBar;

import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

/**
 * @author philipp.bockhorn
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public abstract class MainPanel extends JPanel {
	
	Menu menu;
	
	private boolean clean = true;
	
	public static final int ACTION_ID_CLOSE = 1;
	public static final int ACTION_ID_NOTE_ADD = 2;
	public static final int ACTION_ID_NOTE_SEARCH = 3;
	public static final int ACTION_ID_NOTE_SHOW = 4;
	public static final int ACTION_ID_NOTE_EDIT = 5;
	public static final int ACTION_ID_NOTE_DELETE = 6;
	public static final int ACTION_ID_CATEGORY_ADD = 7;
	public static final int ACTION_ID_CATEGORY_DELETE = 8;
	public static final int ACTION_ID_HELP = 9;
	public static final int ACTION_ID_NOTE_RESET = 10;
	public static final int ACTION_DIRTY = 11;
	public static final int ACTION_NOTE_SAVE = 12;
	public static final int ACTION_ID_SEARCH_SEARCH = 13;
	
    
    GridBagLayout gbl = new GridBagLayout();
    JPanel centerPanel = new JPanel();
    BorderLayout blayout = new BorderLayout();
    GridBagConstraints gbc;
    
    JLabel lblAuthor;
    JTextField txtAuthor;
    JLabel lblFill;
    
    JPanel panelHierarchy;
    JLabel lblHierarchy;
    
    JButton btnReset;
    
    //sets the rownumber
    int rowCounter = 0;
    
    public MainPanel() {
        makegbc();
       // setBackground(Color.lightGray);
		setLayout(blayout);
		generateComponents();
		addComponents();      
    }
    
    public void addComponents() {

        //add the menu to the layout
        //layoutComponent(menu.createMenuBar(), 0, rowCounter, 4, 1);
        //switch to the next row (1)
    	//rowCounter++;
    	centerPanel.setLayout(gbl);
        this.add(menu.createMenuBar(),BorderLayout.NORTH);
        this.add(centerPanel, BorderLayout.CENTER);
    }
        
    public void generateComponents() {
    	 //Menu
        menu = new Menu(this);
    	lblAuthor = new JLabel(InfoResources.getResourceString("infopanel.label.autor.text"));
    	panelHierarchy = new JPanel();
    	
    }

    protected void layoutComponent(JComponent variable, int x, int y, int width, int height, double weightx, double weighty, boolean both) {
        
		gbc.fill = GridBagConstraints.HORIZONTAL;
		
        if(both) {
            
           gbc.fill = GridBagConstraints.BOTH;    
        }
        
		gbc.gridx = x;
		gbc.gridy = y;
		gbc.gridwidth = width;
		gbc.gridheight = height;
		gbc.weightx = weightx;
		gbc.weighty = weighty;
		gbc.anchor = GridBagConstraints.SOUTHWEST;
		gbl.setConstraints(variable, gbc);
		centerPanel.add(variable);
				
    }

    protected void layoutComponent(JComponent variable, int x, int y, int width, int height) {
        
        double dwX = 0.0; // default weight x (for gridbagconstraints)
        double dwY = 0.0; // default weight y (for gridbagconstraints)
   
       layoutComponent(variable, x, y, width, height, dwX, dwY, false);
    }
    
    protected void layoutComponent(JComponent variable, int x, int y) {
        
        layoutComponent(variable, x, y, 1, 1);
    }

    private void makegbc() {
        
        gbc = new GridBagConstraints();
		gbc.insets = new Insets(1, 1, 1, 1);
	}
    
    protected void setMenu(Menu menu) {
    	this.menu = menu;
    }
    
    public Action getAction(int action) throws IllegalActionModifierException {
    	
    	return menu.getAction(action);
    }
    
    public MyDocumentListener getDocumentListener() {
    	return menu.getDocumentListener();
    }
    
    public Menu getMenu(){
    	return menu;
    }
    
    /**
     * @param b True if the panel is clean, false if the panel is dirty.
     */
    public void setClean(boolean b) {
    	this.clean = b;
    }
}
