/*
 * Created on 30.11.2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package gui;

import gui.actions.ActionDirty;
import gui.actions.ActionHelpAbout;
import gui.actions.ActionCategoryAdd;
import gui.actions.ActionCategoryDelete;
import gui.actions.ActionDataClose;
import gui.actions.ActionHelpHelp;
import gui.actions.ActionNoteAdd;
import gui.actions.ActionNoteDelete;
import gui.actions.ActionNoteEdit;
import gui.actions.ActionNoteReset;
import gui.actions.ActionNoteSave;
import gui.actions.ActionNoteSearch;
import gui.actions.ActionNoteShow;
import gui.actions.ActionSearchSearch;
import gui.actions.MenuBarAction;
import gui.actions.MyDocumentListener;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;

import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

/**
 * @author philipp.bockhorn
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class Menu {

    //Images
   static  ImageIcon search = ResourceAnchor.getImageIcon("search.gif");
   static  ImageIcon add = ResourceAnchor.getImageIcon("add.gif");
   static  ImageIcon close = ResourceAnchor.getImageIcon("close.gif");
   static  ImageIcon delete = ResourceAnchor.getImageIcon("delete.gif");
   static  ImageIcon edit = ResourceAnchor.getImageIcon("edit.gif");
   static  ImageIcon help = ResourceAnchor.getImageIcon("help.gif");
   static  ImageIcon about = ResourceAnchor.getImageIcon("about.gif");
   static ImageIcon show = ResourceAnchor.getImageIcon("show.gif");
   

    //Data Actions


	Action dataAction;
	ActionDataClose closeDataAction;
	
	//Note Actions
	Action noteAction;
	ActionNoteAdd addAction;
	ActionNoteSearch searchAction;
	ActionNoteShow showAction;
	ActionNoteEdit editAction;
	ActionNoteDelete deleteAction;
	ActionNoteReset resetAction;
	ActionNoteSave saveAction;
	
	//Category Actions
	Action categoryAction;
	ActionCategoryAdd addCategoryAction;
	ActionCategoryDelete deleteCategoryAction;
	
	//Help Actions
	Action helpAction;
	ActionHelpHelp helpHelpAction;
	ActionHelpAbout helpAboutAction;
	
	ActionSearchSearch searchSearchAction;
	//Dirty Action
	ActionDirty dirtyAction;
	MyDocumentListener documentListener;

  public Menu(MainPanel mainPanel) {
    
     dataAction = new MenuBarAction("menu.ActionNote.data.text");
     closeDataAction = new ActionDataClose(mainPanel, "menu.ActionNote.data.close.text", close, "menu.ActionNote.data.close.desc", KeyStroke.getKeyStroke(KeyEvent.VK_Q, ActionEvent.ALT_MASK));
    
     //Note Actions
     noteAction = new MenuBarAction("menu.ActionNote.note.text");
     addAction = new ActionNoteAdd(mainPanel, "menu.ActionNote.note.add.text", add, "menu.ActionNote.note.add.desc", KeyStroke.getKeyStroke(KeyEvent.VK_N, ActionEvent.ALT_MASK));
     searchAction = new ActionNoteSearch(mainPanel, "menu.ActionNote.note.search.text", search, "menu.ActionNote.note.search.desc", KeyStroke.getKeyStroke(KeyEvent.VK_S, ActionEvent.ALT_MASK));
     showAction = new ActionNoteShow(mainPanel, "menu.ActionNote.note.show.text", show, "menu.ActionNote.note.show.desc", KeyStroke.getKeyStroke(KeyEvent.VK_A, ActionEvent.ALT_MASK));
     editAction = new ActionNoteEdit(mainPanel, "menu.ActionNote.note.edit.text", edit, "menu.ActionNote.note.edit.desc", KeyStroke.getKeyStroke(KeyEvent.VK_B, ActionEvent.ALT_MASK));
     deleteAction = new ActionNoteDelete(mainPanel, "menu.ActionNote.note.delete.text", delete, "menu.ActionNote.note.delete.desc", KeyStroke.getKeyStroke(KeyEvent.VK_L, ActionEvent.ALT_MASK));
     resetAction = new ActionNoteReset(mainPanel, "menu.ActionNote.note.reset.text", null, "menu.ActionNote.note.reset.desc", KeyStroke.getKeyStroke(KeyEvent.VK_R, ActionEvent.ALT_MASK));
     saveAction = new ActionNoteSave(mainPanel, "menu.ActionNote.note.save.text", null, "menu.ActionNote.note.save.desc", KeyStroke.getKeyStroke(KeyEvent.VK_S, ActionEvent.CTRL_MASK));
     
     //Category Actions
     categoryAction = new MenuBarAction("menu.ActionNote.category.category.text");
     addCategoryAction = new ActionCategoryAdd(mainPanel, "menu.ActionNote.category.add.text", add, "menu.ActionNote.category.add.desc", KeyStroke.getKeyStroke(KeyEvent.VK_C, ActionEvent.ALT_MASK));
     deleteCategoryAction = new ActionCategoryDelete(mainPanel, "menu.ActionNote.category.delete.text", delete, "menu.ActionNote.category.delete.desc",KeyStroke.getKeyStroke(KeyEvent.VK_D, ActionEvent.ALT_MASK));
    
     //Help Actions
     helpAction = new MenuBarAction("menu.ActionNote.help.help.text");
     helpHelpAction = new ActionHelpHelp(mainPanel, "menu.ActionNote.help.helphelp.text", help, "menu.ActionNote.help.helphelp.desc", KeyStroke.getKeyStroke(KeyEvent.VK_H, ActionEvent.ALT_MASK));
     helpAboutAction = new ActionHelpAbout(mainPanel, "menu.ActionNote.help.about.text", about, "menu.ActionNote.help.about.desc", KeyStroke.getKeyStroke(KeyEvent.VK_I, ActionEvent.ALT_MASK));
     
     searchSearchAction = new ActionSearchSearch(mainPanel, "menu.ActionNote.note.search.text", null, "menu.ActionNote.note.search.desc", null);
     //Dirty Action
     dirtyAction = new ActionDirty();
     documentListener = new MyDocumentListener(mainPanel);
  }
  


    public JMenuBar createMenuBar() {
        
	    JMenuBar menuBar;
	    JMenu dataMenu, noteMenu, catMenu, helpMenu;
	    JMenuItem menuItem;
	    
	    // Creates a menu bar
	    menuBar = new JMenuBar();
	    
	    // Creates a menu Data, Note and Category
        dataMenu = createMenu(dataAction, menuBar);
        noteMenu = createMenu(noteAction, menuBar);
        catMenu = createMenu(categoryAction, menuBar);
        helpMenu = createMenu(helpAction, menuBar);
        
        // menu item close for DataMenu
        menuItem = addMenuItem(closeDataAction, dataMenu);
                
        //menu item add, search, show, edit and delete for NoteMenu
        menuItem = addMenuItem(addAction, noteMenu);
        menuItem = addMenuItem(searchAction, noteMenu);
        menuItem = addMenuItem(showAction, noteMenu);
        menuItem = addMenuItem(editAction, noteMenu);
        menuItem = addMenuItem(deleteAction, noteMenu);
        
        //menu item add and delete for CategoryMenu
        menuItem = addMenuItem(addCategoryAction, catMenu);
        menuItem = addMenuItem(deleteCategoryAction, catMenu);

        // menu item HelpMenu
        menuItem = addMenuItem(helpHelpAction, helpMenu);    
        menuItem = addMenuItem(helpAboutAction, helpMenu);  
       
        return menuBar;
    }
    
    private JMenuItem addMenuItem(Action adc, JMenu menu){
    	JMenuItem menuItem = new JMenuItem(adc);
        menu.add(menuItem);
        menuItem.setAction(adc);
    	return menuItem;
    }
    
    private JMenu createMenu(Action adc, JMenuBar menuBar){
        JMenu menu = new JMenu(adc);
        menuBar.add(menu);
    	return menu;
    }
    
    /**
     * 
     * 
     * @param action
     * @return
     * @throws IllegalActionModifierException
     */
    public Action getAction(int action) throws IllegalActionModifierException{
		
    	switch(action) {
    		case MainPanel.ACTION_ID_CLOSE: return closeDataAction;
    		case MainPanel.ACTION_ID_NOTE_ADD: return addAction;
    		case MainPanel.ACTION_ID_NOTE_SEARCH: return searchAction;
    		case MainPanel.ACTION_ID_NOTE_SHOW: return showAction;
    		case MainPanel.ACTION_ID_NOTE_EDIT: return editAction;
    		case MainPanel.ACTION_ID_NOTE_DELETE: return deleteAction;   		
    		case MainPanel.ACTION_ID_CATEGORY_ADD: return addCategoryAction;   			
    		case MainPanel.ACTION_ID_CATEGORY_DELETE: return deleteCategoryAction;
    		case MainPanel.ACTION_ID_HELP: return helpHelpAction;
    		case MainPanel.ACTION_ID_NOTE_RESET: return resetAction;
    		case MainPanel.ACTION_DIRTY: return dirtyAction;
    		case MainPanel.ACTION_NOTE_SAVE: return saveAction;
    		case MainPanel.ACTION_ID_SEARCH_SEARCH: return searchSearchAction;
    		default: throw new IllegalActionModifierException();
    	}
    }
    
    public MyDocumentListener getDocumentListener() {
    	return documentListener;
    }
}
