package gui;
import gui.jtable.MySelectionListener;
import gui.jtable.MyTableModel;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;

import control.ControllerImplementation;
import control.ControllerInterface;
import db.info.Info;

/**
 * @author philipp.bockhorn
 */
public class Search extends MainPanel {
	
	Menu menu; 
	
	
    // Reference to JLabel
    JLabel lblFullTextSearch;
    JLabel lblTitleSearch;
    //JLabel lblAuthor;
    JLabel lblVDate;
    JLabel lblBDate;
    //JLabel lblCategory;
    //JLabel lblFill;
    
    JLabel lblResult;
    JPanel pnlresult;
    
    // References to JTextField
    JTextField txtFullTextSearch;
    JTextField txtTitleSearch;
    //JTextField txtAuthor;
    JTextField txtVDate;
    JTextField txtBDate;
    //JTextField txtCategory;
    

    // References to JButtons
    JButton btnSearch;
    //JButton btnReset;
    JButton btnShow;
    JButton btnEdit;
    JButton btnDelete;
    
    // References to JTable
    JTable tblResult;
    
    //References to JScrollPane
    JScrollPane scrollpane;
    
    //Collection c;
   
    // References to LineCanvas
    LineCanvas lnCanvas1;
    LineCanvas lnCanvas2;
    
    // Reference to controller interface
    ControllerInterface controllerInterface;
       
    
    public void generateComponents() {
    	 super.generateComponents();
    	 menu = getMenu();
            // JLabel werden erstellt
        lblFullTextSearch = new JLabel(InfoResources.getResourceString("search.JLabel.FullTextSearch.text")+":");
        lblTitleSearch = new JLabel(InfoResources.getResourceString("search.JLabel.TitleSearch.text")+":");
        lblAuthor = new JLabel(InfoResources.getResourceString("search.JLabel.AuthorSearch.text")+":");
        lblVDate = new JLabel(InfoResources.getResourceString("search.JLabel.VDate.text")+":");
        lblBDate = new JLabel(InfoResources.getResourceString("search.JLabel.BDate.text")+":");
        lblHierarchy = new JLabel(InfoResources.getResourceString("search.JLabel.Hierarchy.text")+":");
        lblFill = new JLabel("");
        lblResult = new JLabel(InfoResources.getResourceString("search.JLabel.Result.text"));
        
        pnlresult = new JPanel();
        pnlresult.setLayout(new GridLayout(1, 1));
        
        // JTextField werden erstellt
        txtFullTextSearch = new JTextField("");
        txtTitleSearch = new JTextField("");
        txtAuthor = new JTextField("");
        txtVDate = new JTextField("");
        txtBDate = new JTextField("");
        //txtCategory = new JTextField("");

        // JButtons werden erstellt
        try {
        btnSearch = new JButton(menu.getAction(MainPanel.ACTION_ID_SEARCH_SEARCH));
        btnReset = new JButton(menu.getAction(MainPanel.ACTION_ID_NOTE_RESET));
       	btnShow = new JButton(menu.getAction(MainPanel.ACTION_ID_NOTE_SHOW));
        btnEdit = new JButton(menu.getAction(MainPanel.ACTION_ID_NOTE_EDIT));
        btnDelete = new JButton(menu.getAction(MainPanel.ACTION_ID_NOTE_DELETE));
        } catch (IllegalActionModifierException e) {
			System.out.println("Illegal Action Modifier");;
		}
	   
        
        // JTable wird erstellt
        tblResult = new JTable();
        tblResult.setDragEnabled(false);
        MySelectionListener mySL = new MySelectionListener(tblResult, this);
        tblResult.addMouseListener(mySL);
        tblResult.getSelectionModel().addListSelectionListener(mySL); 
        scrollpane = new JScrollPane(tblResult);
        
	    
	    // LineCanvas wird erstellt
	    lnCanvas1 = new LineCanvas();
	    lnCanvas2 = new LineCanvas();
	    
    }
    
    
    public void addComponents() {
        
    	super.addComponents();
        int width = InfoResources.getResourceInt("gui.InfoPanel.addComponents.w");
    	int height = InfoResources.getResourceInt("gui.InfoPanel.addComponents.h");
                
        // Suche - Label
		layoutComponent(lblFullTextSearch, 0, rowCounter);
		lblFullTextSearch.setPreferredSize(new Dimension (width, height));
		// Suche - Textfeld
		layoutComponent(txtFullTextSearch, 1, rowCounter);
		txtFullTextSearch.setPreferredSize(new Dimension (width, height));
		// Test - Label : Vertikal Ruler
		layoutComponent(lblFill, 2, rowCounter, 1, 7);
		// Kategorie - Label
		layoutComponent(lblHierarchy, 2, rowCounter);
		//switch to the next row (2)
		rowCounter++;

		// Titel Suche - Label
		layoutComponent(lblTitleSearch, 0, rowCounter);
		lblTitleSearch.setPreferredSize(new Dimension (width, height));
		// Titel Suche - Textfeld
		layoutComponent(txtTitleSearch, 1, rowCounter);
		txtTitleSearch.setPreferredSize(new Dimension (width, height));
		// Kategorie - Textfeld
		layoutComponent(panelHierarchy, 2, rowCounter, 1, 6, 1.0, 1.0, true);
		//switch to the next row (3)
		rowCounter++;
		
		// Autor - Label
		layoutComponent(lblAuthor, 0, rowCounter);
		// Autor - Textfeld
		layoutComponent(txtAuthor, 1, rowCounter);
		//switch to the next row (4)
		rowCounter++;
		
		// Datum - Label
		layoutComponent(lblVDate, 0, rowCounter);
		// Datum - Textfeld
		layoutComponent(txtVDate, 1, rowCounter);
		//switch to the next row (5)
		rowCounter++;
		
		// Datum - Label
		layoutComponent(lblBDate, 0, rowCounter);
		// Datum - Textfeld
		layoutComponent(txtBDate, 1, rowCounter);
		//switch to the next row (6)
		rowCounter++;
		
		// Fill - Label
		layoutComponent(lblFill, 0, rowCounter);
		//switch to the next row (7)
		rowCounter++;

		// Suchen - Button
		layoutComponent(btnSearch, 0, rowCounter);
			//TODO if(txtFullTextSearch.is)
			//btnSearch.setEnabled(false);
		// Reset - Button
		layoutComponent(btnReset, 1, rowCounter);
		//switch to the next row (8)
		rowCounter++;
		
		// Fill2 - Label
		layoutComponent(lnCanvas1, 0, rowCounter, 4, 1);
		//switch to the next row (9)
		rowCounter++;
		
		// Fill - Label
		layoutComponent(lblFill, 0, rowCounter);
		//switch to the next row (10)
		rowCounter++;
		
		//Ergebnis - Panel
        layoutComponent(pnlresult, 0, rowCounter, 4, 1, 1.0, 1.0, true);
        //switch to the next row (11)
        rowCounter++;
		
		// Fill3 - Label
		layoutComponent(lnCanvas2, 0, rowCounter, 4, 1);
		//switch to the next row (12)
		rowCounter++;
		
		//Bottom - Panel
		JPanel pnlBottom = new JPanel();
		// Show - Button
		pnlBottom.add(btnShow);
		// Edit - Button
		pnlBottom.add(btnEdit);
		// Delete - Button 
		pnlBottom.add(btnDelete);
		//
		pnlBottom.setLayout(new FlowLayout(FlowLayout.LEFT));
		//add the bottom panel to the layout
		layoutComponent(pnlBottom, 0, rowCounter, 4 ,1);
		
		/*
		 * ActionListeners
		 */
		controllerInterface = ControllerImplementation.getInstance();
		
		//ActionListeners to determine if the panel is dirty
		txtFullTextSearch.getDocument().addDocumentListener(super.getDocumentListener());
		txtTitleSearch.getDocument().addDocumentListener(super.getDocumentListener());
		txtAuthor.getDocument().addDocumentListener(super.getDocumentListener());
		txtBDate.getDocument().addDocumentListener(super.getDocumentListener());
		txtVDate.getDocument().addDocumentListener(super.getDocumentListener());
		try {
			btnReset.addActionListener(super.getAction(MainPanel.ACTION_DIRTY));
		} catch (IllegalActionModifierException e) {
			System.out.println("Illegal Action Modifier");
		}
		
		
	}
    
    
    public void checkContent(Collection c){
    		
    		//this.c = c;
    	    	if(0 == c.size()) {
    		pnlresult.remove(scrollpane);
    		pnlresult.add(lblResult);
    		pnlresult.updateUI();
    		
    	} else if (1 == c.size()) {
    		Iterator it = c.iterator();
    		Info info = (Info)it.next();
    		GUIFrame.switchToPanel(this, GUIFrame.PANELTYPE_SHOW, info);
    		
    	} else {
    		pnlresult.remove(lblResult);
    		MyTableModel myTM = new MyTableModel(c);
    		tblResult.setModel(myTM);
    		pnlresult.add(scrollpane);
    		pnlresult.updateUI();
    		
    	}
    }
    
    public Collection getSelectedData() {

    	Vector vector = new Vector();
    	
    	Vector vec = ((MyTableModel)tblResult.getModel()).getVector();
		
    	
    	int[] a = tblResult.getSelectedRows();
		for(int i = 0; i < a.length; i++) {
			
			vector.add(vec.get(a[i]));
		}
		return vector;
	}
    
    public JTable getJTable() {
    	return tblResult;
    }
        
}