
package gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import db.info.Info;

/**
 * @author jennifer.meyer, uemi.oezcan
 */
public class SwitchListener implements ActionListener {

	InfoPanel myPanel;
	
	public SwitchListener(InfoPanel infoPanel){
		myPanel = infoPanel;
	}
	
	public void actionPerformed(ActionEvent ae) {
	
		if(myPanel.getPartnerPanel() == null){
			Info info = myPanel.getInfo();
			if(myPanel instanceof Show){
				GUIFrame.switchToPanel(myPanel, GUIFrame.PANELTYPE_CREATE_OR_CHANGE, info);
			} else if(myPanel instanceof Create){
				GUIFrame.switchToPanel(myPanel, GUIFrame.PANELTYPE_SHOW, info);
			}
		} else {
			GUIFrame myFrame = GUIFrame.getFrameFromPanel(myPanel);
			myFrame.setContentPane(myPanel.getPartnerPanel());
		}
	}

}
