package gui.actions;

import gui.Create;
import gui.GUI;
import gui.GUIFrame;
import gui.MainPanel;
import gui.Search;
import gui.Show;

import java.awt.event.ActionEvent;

import javax.swing.ImageIcon;
import javax.swing.KeyStroke;

import db.info.Info;

/**
 * @author jenny.meyer
 */
public class ActionNoteAdd extends InfoAction {

    /**
     * @see InfoAction#InfoAction(InfoPanel, String, ImageIcon, String, KeyStroke)
     */
    public ActionNoteAdd (MainPanel mp, String text, ImageIcon icon, String desc, KeyStroke acceleratorKey) {
        super(mp, text, icon, desc, acceleratorKey);
    }  
    
    /**
     * 
     */
    public void actionPerformed(ActionEvent ae) {
        
        GUI gui = (GUI) GUI.getInstance();
        super.actionPerformed(ae);
        MainPanel mainPanel = getThePanel();
        
        if(mainPanel instanceof Search) {
            
            GUIFrame.openNewFrame(GUIFrame.PANELTYPE_CREATE_OR_CHANGE, null);
            
        } else if(mainPanel instanceof Create) {
            
            GUIFrame.openNewFrame(GUIFrame.PANELTYPE_CREATE_OR_CHANGE, null);
            
        } else if(mainPanel instanceof Show) {
            
            Info info = gui.getInfo(ae);
            GUIFrame.openNewFrame(GUIFrame.PANELTYPE_CREATE_OR_CHANGE, info);
        }
    }
}
