package gui.actions;

import gui.GUI;
import gui.GUIFrame;
import gui.InfoPanel;
import gui.MainPanel;
import gui.Menu;
import gui.Search;
import gui.Show;


import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Iterator;

import javax.swing.ImageIcon;
import javax.swing.KeyStroke;

import control.ControllerImplementation;
import control.ControllerInterface;
import db.info.Info;

/**
 * @author jenny.meyer
 */
public class ActionNoteDelete extends InfoAction {

    /**
     * @see InfoAction#InfoAction(InfoPanel, String, ImageIcon, String, KeyStroke)
     */
    public ActionNoteDelete (MainPanel mp, String text, ImageIcon icon, String desc, KeyStroke acceleratorKey) {
        
        super(mp, text, icon, desc, acceleratorKey);
    }  
    
    /**
     * 
     */
    public void actionPerformed(ActionEvent ae) {
    	GUI gui = (GUI) GUI.getInstance();
    	ControllerInterface control = ControllerImplementation.getInstance();
    	super.actionPerformed(ae);
        MainPanel mainPanel = getThePanel();
        Menu menu = super.provideMenu();
        
        if(mainPanel instanceof Search) {
        	Collection c = ((Search) mainPanel).getSelectedData();  
        	Iterator it = c.iterator();
        	while(it.hasNext()){
        		Info info = (Info) it.next();
        		control.remove(info);
        	}
		Search search = (Search) mainPanel;
        	Collection coll = control.search(gui.getAllFields(ae));
    		search.checkContent(coll);
            
        } else if(mainPanel instanceof Show) {
        	Collection c = ((Search) mainPanel).getSelectedData();  
        	Iterator it = c.iterator();
        	while(it.hasNext()){
        		Info info = (Info) it.next();
        		control.remove(info);
        	}
        	GUIFrame frame = GUIFrame.getFrameFromPanel(mainPanel);
        	frame.dispose();
         }        
    }
}
