package gui.actions;

import gui.Create;
import gui.GUI;
import gui.GUIFrame;
import gui.InfoPanel;
import gui.MainPanel;
import gui.Search;
import gui.Show;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Iterator;

import javax.swing.ImageIcon;
import javax.swing.KeyStroke;

import db.info.Info;

/**
 * @author jenny.meyer
 */
public class ActionNoteEdit extends InfoAction {

    /**
     * @see InfoAction#InfoAction(InfoPanel, String, ImageIcon, String, KeyStroke)
     */
    public ActionNoteEdit (MainPanel mp, String text, ImageIcon icon, String desc, KeyStroke acceleratorKey) {
        super(mp, text, icon, desc, acceleratorKey);
    }  
    
    /**
     * 
     */
    public void actionPerformed(ActionEvent ae) {

        GUI gui = (GUI) GUI.getInstance();
        super.actionPerformed(ae);
        MainPanel mainPanel = getThePanel();
        
        if(mainPanel instanceof Search) {
            
            Collection col = ((Search) mainPanel).getSelectedData();
            Iterator it = col.iterator();
            Info info = (Info) it.next();
            GUIFrame.openNewFrame(GUIFrame.PANELTYPE_CREATE_OR_CHANGE, info);
            
        } else if(mainPanel instanceof Create) {
            
            /*
             * the user can't click the button edit in the create
             * panel, so it should never come into this if statement
             */
            
        } else if(mainPanel instanceof Show) {

            Info info = gui.getInfo(ae);
            InfoPanel myPanel = (InfoPanel) getThePanel();
            myPanel.setInfoValuesIntoTheFields(info);
            GUIFrame.switchToPanel(mainPanel, GUIFrame.PANELTYPE_CREATE_OR_CHANGE, info);
        }
    }
}
