/*
 * Created on 08.12.2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package gui.actions;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import gui.GUI;
import gui.MainPanel;
import javax.swing.ImageIcon;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;

/**
 * @author fabian.kng
 *
 * This action is called when the user clicks the 'Reset'-Button.
 * It resets all the JTextComponents(JTextField and JTextArea).
 */
public class ActionNoteReset extends InfoAction {

	public ActionNoteReset(MainPanel mp, String text, ImageIcon icon,
			String desc, KeyStroke acceleratorKey) {
		super(mp, text, icon, desc, acceleratorKey);
	}

	public void actionPerformed(ActionEvent e) {
		super.actionPerformed(e);
		GUI gui = (GUI) GUI.getInstance();
		MainPanel activPanel = getThePanel();
		deleteTextFields(activPanel);
	}

	/**
	 * @param component
	 */
	private void deleteTextFields(Component component) {
		if (component instanceof JTextComponent) {
			JTextComponent txtComp = (JTextComponent) component;
			txtComp.setText("");
			if(null != txtComp.getName()&& txtComp.getName().equals("txtAuthor")){
				txtComp.setText(System.getProperty("user.name"));
			}
		} else {
			if (component instanceof Container) {
				Component[] a = ((Container) component).getComponents();
				for (int i = 0; i < a.length; i++) {
					deleteTextFields(a[i]);
				}
			}

		}
	}
}

