
package gui.actions;

import gui.Create;
import gui.GUI;
import gui.GUIFrame;
import gui.MainPanel;
import gui.Search;
import gui.Show;

import java.awt.event.ActionEvent;

import javax.swing.ImageIcon;
import javax.swing.KeyStroke;

import db.info.Info;

/**
 * @author philipp.bockhorn
 */
public class ActionNoteSearch extends InfoAction {

    /**
     * @see InfoAction#InfoAction(InfoPanel, String, ImageIcon, String, KeyStroke)
     */
    public ActionNoteSearch (MainPanel mp, String text, ImageIcon icon, String desc, KeyStroke acceleratorKey) {
        super(mp, text, icon, desc, acceleratorKey);
    }  
    
    /**
     * 
     */
    public void actionPerformed(ActionEvent ae) {
    	GUI gui = (GUI) GUI.getInstance();
        super.actionPerformed(ae);

        MainPanel mainPanel = gui.getPanelFromActionEvent(ae);
        
        if(mainPanel instanceof Search) {
            
            GUIFrame.openNewFrame(GUIFrame.PANELTYPE_SEARCH, null);
            
        } else if(mainPanel instanceof Create) {
            Create createPanel = (Create) mainPanel;
            if(createPanel.isEmpty()) {
                Info info = gui.getInfo(ae);
                GUIFrame.switchToPanel(mainPanel, GUIFrame.PANELTYPE_SEARCH, info);
            } else {
                GUIFrame.openNewFrame(GUIFrame.PANELTYPE_SEARCH, null);
            }
        } else if(mainPanel instanceof Show) {
            Info info = gui.getInfo(ae);
            GUIFrame.switchToPanel(mainPanel, GUIFrame.PANELTYPE_SEARCH, info);
         }
    }
}