package gui.actions;

import gui.Create;
import gui.GUI;
import gui.GUIFrame;
import gui.MainPanel;
import gui.Search;
import gui.Show;
import gui.jtable.MyTableModel;

import java.awt.event.ActionEvent;

import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.KeyStroke;

import control.ControllerImplementation;
import control.ControllerInterface;

import db.info.Info;

/**
 * @author jenny.meyer
 */
public class ActionNoteShow extends InfoAction {

    /**
     * @see InfoAction#InfoAction(InfoPanel, String, ImageIcon, String, KeyStroke)
     */
    public ActionNoteShow (MainPanel mp, String text, ImageIcon icon, String desc, KeyStroke acceleratorKey) {
        super(mp, text, icon, desc, acceleratorKey);
    }  
    
    /**
     * 
     */
    public void actionPerformed(ActionEvent ae) {

        GUI gui = (GUI) GUI.getInstance();
        super.actionPerformed(ae);
        MainPanel mainPanel = getThePanel();
        ControllerInterface control = ControllerImplementation.getInstance();
        Info info = gui.getInfo(ae);
        
        if(mainPanel instanceof Search) {
        	Search searchPanel = (Search) mainPanel;
        	JTable jt = searchPanel.getJTable();
        	int i = jt.getSelectedRow();
            
            GUIFrame.openNewFrame(GUIFrame.PANELTYPE_SHOW, getInfos(i, jt));
            
        } else if(mainPanel instanceof Create) {
            //GUIFrame.switchToPanel(mainPanel, GUIFrame.PANELTYPE_CREATE_OR_CHANGE, info);
            control.save(info);
            
        } else if(mainPanel instanceof Show) {
            
            /*
             * should never come here, because the show button is disabled
             * in the show panel. 
             */
        }
    } 
    
	  public Info getInfos(int position, JTable jt) {
	  	MyTableModel mt = (MyTableModel) jt.getModel();
	  	return (Info) mt.getVector().get(position);
	  }
}
