package gui.jtable;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import db.DBInterface;
import db.Singelton;
import db.info.Info;
import gui.IllegalActionModifierException;
import gui.InfoPanel;
import gui.GUIFrame;

public class MySelectionListener extends MouseAdapter implements ListSelectionListener{

	gui.Search s;
	MyTableModel m;
	DBInterface database = Singelton.getInstance();
	JTable jt;
	int[] a;
	
	public MySelectionListener(JTable t, gui.Search s) {
		jt = t;
		this.s = s;
		a = jt.getSelectedRows();
		
		try {
			s.getAction(InfoPanel.ACTION_ID_NOTE_SHOW).setEnabled(false);
			s.getAction(InfoPanel.ACTION_ID_NOTE_EDIT).setEnabled(false);
			s.getAction(InfoPanel.ACTION_ID_NOTE_DELETE).setEnabled(false);
		} catch (IllegalActionModifierException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
	}
	
	public void valueChanged(ListSelectionEvent e) {
		m = (MyTableModel) jt.getModel();
		//Search s = m.s;
		try{
			int selectedRows = jt.getSelectedRowCount();
			s.getAction(InfoPanel.ACTION_ID_NOTE_SHOW).setEnabled(selectedRows == 1);
			s.getAction(InfoPanel.ACTION_ID_NOTE_EDIT).setEnabled(selectedRows == 1);
			s.getAction(InfoPanel.ACTION_ID_NOTE_DELETE).setEnabled(selectedRows > 0);
		}catch(IllegalActionModifierException exc) {
			System.out.println("Action not allowed!");
			}
	}
	
	
	  public void mouseClicked(MouseEvent event){
	    if(event.getClickCount() == 2) {
	    	JTable tbl = (JTable) event.getSource();
	    	int i = tbl.getSelectedRow();
	    	GUIFrame.openNewFrame(GUIFrame.PANELTYPE_SHOW, getInfos(i));
	    }
	  }
	  
	  
	  public Info getInfos(int position) {
	  	return (Info) m.getVector().get(position);
	  }
	
}