package gui.jtable;

import gui.GUIUtility;

import java.util.Collection;
import java.util.Iterator;

import javax.swing.table.AbstractTableModel;
import db.info.*;
import java.util.*;


public class MyTableModel extends AbstractTableModel{

	Vector results = new Vector();
	//public gui.Search s;
	String[] array = new String[] {"Title", "Author", "Date"};
	
	public MyTableModel(Collection c) {
		Iterator it = c.iterator();
		while(it.hasNext()){
			results.add(it.next());
		}
	}

	public Vector getVector() {
		return results;
	}
	
	public int getColumnCount() {
		return 3;
	}

	public int getRowCount() {
		
		return results.size();
	}
	
	public String getColumnName(int i) {
		return array[i];
	}

	public Object getValueAt(int rowIndex, int colIndex) {
		
		Info info = (Info) results.get(rowIndex);
		if(colIndex == 0) {
			return info.getTitle();
		} else if(colIndex == 1) {
			return info.getAuthor();
		} else {
			return GUIUtility.format(info.getDate());
		}
	}
	
	
	
	
	
	
}