/**
 * Created on 18.05.2005
 * @author uemi.oezcan, patrizia.moser
 */

package junit;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

import junit.framework.TestCase;
import db.DBInterface;
import db.info.DummyData;
import db.info.Hierarchy;
import db.info.Info;
import control.search.*;

public class DB_TestDummyData2 extends TestCase {

	DBInterface database;
		
	public void setUp(){
	   database = 	db.Singelton.getInstance();
	   Collection allElements = database.getResultSet(null);
	   Iterator it = allElements.iterator();
	   while(it.hasNext()) {
	   	  Info info = (Info) it.next();
	   	  database.removeInfo(info);
	   }
	   DummyData dd = new DummyData();
	   HashSet dummyData = dd.getDummyData();	
	   it = dummyData.iterator();
	   while(it.hasNext()) {
	   	  database.saveInfo((Info) it.next());
	   }
	}
	
	public void testAddAndSearchInfo() {
		TitleSearch ts;
		ts = new TitleSearch("Eclipse");
		Collection resultset;
		SearchCriteria sc = new SearchCriteria();
		sc.add(ts);
		resultset = database.getResultSet(sc);
		assertTrue(1 == resultset.size());
	}
	
	public void testAddAndSearchInfo2() {
		FullTextSearch fts;
		fts = new FullTextSearch("ffnen");
		Collection resultset;
		SearchCriteria sc = new SearchCriteria();
		sc.add(fts);
		resultset = database.getResultSet(sc);
		assertTrue(1 == resultset.size());
	}
	
	public void testAddAndSearchInfo3() {
		FullTextSearch fts;
		fts = new FullTextSearch("doppelklicken");
		Collection resultset;
		SearchCriteria sc = new SearchCriteria();
		sc.add(fts);
		resultset = database.getResultSet(sc);
		assertTrue(2 == resultset.size());
	}
	
	public void testAddAndSearchInfo6() {
		FullTextSearch fts;
		fts = new FullTextSearch("File");
		Collection resultset;
		SearchCriteria sc = new SearchCriteria();
		sc.add(fts);
		resultset = database.getResultSet(sc);
		assertTrue(1 == resultset.size());
	}
	
	public void testTopHierarchy() {
		Hierarchy top = new Hierarchy("top");
		Hierarchy child1 = new Hierarchy(top, "child1");
		Hierarchy child2 = new Hierarchy(top, "child2");
		
		database.setTopHierarchy(top);
		Hierarchy testTop = database.getTopHierarchy();
		
		assertTrue(testTop == top);
		
		Collection col = testTop.getChildren();
		assertTrue(2 == col.size());
	}		
}