/*
 * Decompiled with CFR 0.152.
 */
import eu.gressly.io.Persistent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;

public class Controller
extends WindowAdapter
implements KeyListener {
    public static final long MIN_PAUSE_IN_MILLIS = 120L;
    private long lastKeyEventTime = 0L;
    private char lastKeyChar = '\u0000';
    private char actKeyChar = '\u0000';
    private Model model;

    public Controller(Model m) {
        this.model = m;
    }

    private boolean tooFastTyping() {
        long diff = System.currentTimeMillis() - this.lastKeyEventTime;
        this.lastKeyEventTime = System.currentTimeMillis();
        boolean tooFast = diff <= 120L && this.actKeyChar == this.lastKeyChar;
        this.lastKeyChar = this.actKeyChar;
        return tooFast;
    }

    @Override
    public void keyTyped(KeyEvent e) {
        char ch;
        this.actKeyChar = ch = e.getKeyChar();
        if (this.tooFastTyping()) {
            return;
        }
        this.model.addCharacter(ch);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        int id = e.getKeyCode();
        if (id == 38 || id == 40 || id == 39 || id == 37) {
            this.model.moveCursor(id);
        }
    }

    @Override
    public void windowClosing(WindowEvent e) {
        try {
            Persistent.save(this.model, Model.persistentFileName);
        }
        catch (IOException e1) {
            System.out.println("Error: state could not be saved.");
            e1.printStackTrace();
        }
        System.exit(0);
    }

    public void finalize() throws Throwable {
        System.out.println("Finalizer");
        Persistent.save(this.model, Model.persistentFileName);
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.lastKeyEventTime = System.currentTimeMillis();
    }
}

