/*
 * Decompiled with CFR 0.152.
 */
import eu.gressly.util.event.EventDispatcher;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;

public class Model
implements Serializable {
    public static String persistentFileName = "Setzkasten";
    public int MAX_COLS = 15;
    public int MAX_ROWS = 8;
    private int actCol = 0;
    private int actRow = 0;
    private char[][] data;
    private transient EventDispatcher<PropertyChangeListener> ed;
    PropertyChangeEvent pce = new PropertyChangeEvent(this, "data", null, null);

    public Model() {
        this.ed = new EventDispatcher();
        this.data = new char[this.MAX_ROWS][this.MAX_COLS];
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        if (this.ed == null) {
            this.ed = new EventDispatcher();
        }
        this.ed.addListener(pcl);
    }

    public char getCharAt(int row, int col) {
        return this.data[row][col];
    }

    public void addCharacter(char c) {
        if ('\u007f' == c) {
            this.deleteField();
            return;
        }
        if ('\n' == c) {
            this.newline();
            return;
        }
        if ('\b' == c) {
            this.backspace();
            return;
        }
        this.data[this.actRow][this.actCol] = c;
        this.nextPos();
        this.firePropertyChange();
    }

    private void firePropertyChange() {
        this.ed.dispatch("propertyChange", this.pce);
    }

    public void deleteField() {
        this.actCol = 0;
        this.actRow = 0;
        this.data = new char[this.MAX_ROWS][this.MAX_COLS];
        this.firePropertyChange();
    }

    private void newline() {
        this.actCol = 0;
        ++this.actRow;
        if (this.actRow >= this.MAX_ROWS) {
            this.actRow = 0;
        }
        this.firePropertyChange();
    }

    private void nextPos() {
        this.moveForward(1);
    }

    private void moveForward(int i) {
        int totPos = this.actRow * this.MAX_COLS + this.actCol;
        if ((totPos += i) < 0) {
            totPos += this.MAX_COLS * this.MAX_ROWS;
        }
        this.actRow = (totPos %= this.MAX_COLS * this.MAX_ROWS) / this.MAX_COLS;
        this.actCol = totPos % this.MAX_COLS;
    }

    private void backspace() {
        this.moveForward(-1);
        this.data[this.actRow][this.actCol] = 32;
        this.firePropertyChange();
    }

    public int getActRow() {
        return this.actRow;
    }

    public void setActRow(int row) {
        this.actRow = row;
        this.firePropertyChange();
    }

    public int getActCol() {
        return this.actCol;
    }

    public void setActCol(int col) {
        this.actCol = col;
        this.firePropertyChange();
    }

    public int getWidth() {
        return this.MAX_COLS;
    }

    public int getHeight() {
        return this.MAX_ROWS;
    }

    public boolean hasFocus(int row, int col) {
        return col == this.actCol && row == this.actRow;
    }

    public void moveCursor(int keyCode) {
        if (38 == keyCode && this.actRow > 0) {
            --this.actRow;
        } else if (40 == keyCode && this.actRow < this.MAX_ROWS - 1) {
            ++this.actRow;
        } else if (39 == keyCode && this.actCol < this.MAX_COLS - 1) {
            ++this.actCol;
        } else if (37 == keyCode && this.actCol > 0) {
            --this.actCol;
        }
        this.firePropertyChange();
    }
}

