/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class View
extends JPanel
implements PropertyChangeListener {
    Model model;
    JLabel[][] allLabels;
    Font font;

    public View(Model model, Dimension d) {
        int fontSize = Math.min(d.width * 120 / 1900, d.height * 120 / 1200);
        this.font = new Font("sans-serif", 1, fontSize);
        this.model = model;
        model.addPropertyChangeListener(this);
        this.setLayout(new GridLayout(model.getHeight(), model.getWidth()));
        this.allLabels = new JLabel[model.getHeight()][model.getWidth()];
        int i = 0;
        while (i < model.getHeight()) {
            int j = 0;
            while (j < model.getWidth()) {
                this.allLabels[i][j] = this.generateLabel(i, j);
                ++j;
            }
            ++i;
        }
        this.paintAllChars();
        this.validate();
        this.repaint();
    }

    JLabel generateLabel(int i, int j) {
        JLabel lb = new JLabel("");
        this.add(lb);
        lb.setOpaque(true);
        lb.setVisible(true);
        lb.setHorizontalAlignment(0);
        lb.setFont(this.font);
        lb.setForeground(this.saturatedRandomColor(0, 200));
        lb.setBackground(this.saturatedRandomColor(200, 255));
        return lb;
    }

    private Color saturatedRandomColor(int minBrightness, int maxBrightness) {
        int diffBrightness = maxBrightness - minBrightness;
        int[] c = new int[]{(int)(Math.random() * (double)diffBrightness + (double)minBrightness), (int)(Math.random() * (double)diffBrightness + (double)minBrightness), (int)(Math.random() * (double)diffBrightness + (double)minBrightness)};
        c[(int)(Math.random() * 3.0)] = minBrightness;
        return new Color(c[0], c[1], c[2]);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.paintAllChars();
    }

    public void paintAllChars() {
        int i = 0;
        while (i < this.model.getHeight()) {
            int j = 0;
            while (j < this.model.getWidth()) {
                char c = this.model.getCharAt(i, j);
                JLabel lb = this.allLabels[i][j];
                if (c >= 'a' && c <= 'z' || c == ' ' || c >= 'A' && c <= 'Z') {
                    lb.setText("" + c);
                } else if (c >= '0' && c <= '9') {
                    lb.setText("" + c);
                } else if ("\u00ef\u00bf\u00bd\u00ef\u00bf\u00bd\u00ef\u00bf\u00bd\u00ef\u00bf\u00bd\u00ef\u00bf\u00bd\u00ef\u00bf\u00bd.,?\"'-:;()&!+/".indexOf(c) >= 0) {
                    lb.setText("" + c);
                } else {
                    lb.setText("");
                }
                if (this.model.hasFocus(i, j)) {
                    lb.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(0), BorderFactory.createBevelBorder(1)));
                    lb.setForeground(this.saturatedRandomColor(200, 255));
                    lb.setBackground(this.saturatedRandomColor(0, 200));
                } else {
                    lb.setBorder(null);
                    lb.setForeground(this.saturatedRandomColor(0, 200));
                    lb.setBackground(this.saturatedRandomColor(200, 255));
                }
                ++j;
            }
            ++i;
        }
    }
}

