/*
 * Decompiled with CFR 0.152.
 */
package eu.gressly.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class Persistent {
    static final String PERSISTENT_FILE_NAME_SUFFIX = "joz";

    private static String makePersistentFileName(String persistentFileName) {
        if (persistentFileName.indexOf(46) >= 0) {
            return persistentFileName;
        }
        return String.valueOf(persistentFileName) + "." + PERSISTENT_FILE_NAME_SUFFIX;
    }

    public static void save(Object data, String persistentFileName) throws IOException {
        File file = new File(Persistent.makePersistentFileName(persistentFileName));
        FileOutputStream fos = new FileOutputStream(file);
        GZIPOutputStream gzos = new GZIPOutputStream(fos);
        ObjectOutputStream out = new ObjectOutputStream(gzos);
        out.writeObject(data);
        out.flush();
        out.close();
    }

    public static Object load(String persistentFileName) throws Exception {
        Object result = null;
        File inFile = new File(Persistent.makePersistentFileName(persistentFileName));
        FileInputStream fis = new FileInputStream(inFile);
        GZIPInputStream gzis = new GZIPInputStream(fis);
        ObjectInputStream in = new ObjectInputStream(gzis);
        try {
            result = in.readObject();
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException("Class Not Found in SysTools.load() :\n" + cnfe);
        }
        in.close();
        return result;
    }
}

