/*
 * Decompiled with CFR 0.152.
 */
package eu.gressly.util.event;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class EventDispatcher<L> {
    private ArrayList<L> listeners = new ArrayList(2);

    public void addListener(L listener) {
        this.listeners.add(listener);
    }

    public void removeListener(L listener) {
        this.listeners.remove(listener);
    }

    public void clearListenerList() {
        this.listeners.clear();
    }

    public void dispatchWithExceptions(String eventMethod, Object ... params) throws NoSuchMethodException, IllegalArgumentException {
        ArrayList<L> copiedList = new ArrayList<L>(this.listeners);
        Class[] paramClasses = this.makeClasses(params);
        for (L listener : copiedList) {
            Class<?> lClass = listener.getClass();
            Method meth = lClass.getMethod(eventMethod, paramClasses);
            try {
                meth.setAccessible(true);
                meth.invoke(listener, params);
            }
            catch (IllegalAccessException iaex) {
                System.err.println("Illegal Access in EventDispatcher.dispatch(): " + iaex + " (" + params + ")");
                iaex.printStackTrace();
            }
            catch (InvocationTargetException ite) {
                System.err.println("Invocation Target Exception in EventDispatcher.dispatch(): " + ite + " (" + params + ")");
                ite.printStackTrace();
            }
        }
    }

    public void dispatch(String eventMethod, Object ... params) {
        try {
            this.dispatchWithExceptions(eventMethod, params);
        }
        catch (Exception e) {
            System.err.println("EventDispatcher.dispatch() Exception: " + e);
            e.printStackTrace();
        }
    }

    private Class[] makeClasses(Object ... params) {
        Class[] classes = new Class[params.length];
        int i = 0;
        Object[] objectArray = params;
        int n = 0;
        int n2 = objectArray.length;
        while (n < n2) {
            Object param = objectArray[n];
            classes[i++] = param.getClass();
            ++n;
        }
        return classes;
    }
}

